data{
    int n;
    array[n] int<lower=0> P;
    array[n] int<lower=0> n_known;
    array[n] int<lower=0> pyr;
    array[n] int<lower=0> events_cohort;
    array[n] int<lower=0> events_extra;
    vector[n] age_g2;
    vector[n] age_g3;
    vector[n] sex_g;
}
parameters{
    real beta0;
    vector[3] beta;
    vector[4] gamma;
    vector<lower=0.0001,upper=0.1>[n] prev_known;
}
transformed parameters{
    vector[n] log_lambda;
    {
        for(i in 1:n){
            log_lambda[i] = beta0 + 
                            beta[1]*age_g2[i] +         
                            beta[2]*age_g3[i] +
                            beta[3]*sex_g[i];
        }
    }
    vector[n] lambda;
    vector[n] mean_cohort;
    {
        for(i in 1:n){
            lambda[i] = exp(log_lambda[i]);
            mean_cohort[i] = lambda[i] * pyr[i];
        }
    }
    vector[n] prev;
    vector[n] N;
    vector[n] mean_extra;
    {
        vector[n] n_extra;
        for(i in 1:n){
            prev[i] = inv_logit(gamma[1] + 
                                gamma[2]*age_g2[i] +         
                                gamma[3]*age_g3[i] +
                                gamma[4]*sex_g[i]
                                ) + prev_known[i];
            N[i] = P[i] * prev[i];
            n_extra[i] = N[i] - (prev_known[i]*P[i]);
            mean_extra[i] = lambda[i] * n_extra[i];
        }
    }
}
model{
    // cohort event-rate Likelihood
    for(i in 1:n){
        events_cohort[i] ~ poisson(mean_cohort[i]);
    }
    // cohort event-rate Priors
    beta0 ~ normal(-4.07, 100); //log(13/760)
    for(j in 1:3){
        beta[j] ~ normal(0, 100);
    }
    // extra event-rate Likelihood
    for(i in 1:n){
        events_extra[i] ~ poisson(mean_extra[i]);
        n_known[i] ~ binomial(P[i],prev_known[i]);
    }
    // Event-Rate Priors
    for(j in 1:4){
        gamma[j] ~ normal(0, 100);
    }
}
generated quantities{
    vector[n] ResDev_cohort;
    vector[n] ResDev_extra;
    real ResDevTotal_cohort;
    real ResDevTotal_extra;
    real ResDevTotal;
    {
        real local_param;
        for(i in 1:n){
            local_param = 2 * ( (mean_cohort[i]- events_cohort[i]) + events_cohort[i] * log(events_cohort[i] / mean_cohort[i]) );
            ResDev_cohort[i] = events_cohort[i]==0 ? 2*mean_cohort[i] : local_param;
            local_param = 2 * ( (mean_extra[i]- events_extra[i]) + events_extra[i] * log(events_extra[i] / mean_extra[i]) );
            ResDev_extra[i] = events_extra[i]==0 ? 2*mean_extra[i] : local_param;
        }
        ResDevTotal_cohort = sum(ResDev_cohort);
        ResDevTotal_extra = sum(ResDev_extra);
        ResDevTotal = ResDevTotal_cohort + ResDevTotal_extra;
    }
    //  log-likelihood
    vector[n] log_likelihood_cohort;
    vector[n] log_likelihood_extra;
  {
    for(i in 1:n){
      log_likelihood_cohort[i] = poisson_lpmf(events_cohort[i] | mean_cohort[i]);
      log_likelihood_extra[i] = poisson_lpmf(events_extra[i] | mean_extra[i]);
    }
  }
  real log_lik;
  {
    log_lik = sum(log_likelihood_cohort) + sum(log_likelihood_extra);
  }
}